/*
 * Decompiled with CFR 0.152.
 */
package com.vistara.sdk.alert;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.vistara.sdk.dto.Results;
import com.vistara.sdk.dto.alert.Alert;
import com.vistara.sdk.dto.device.Device;
import com.vistara.sdk.dto.response.Response;
import com.vistara.sdk.utils.APIConstants;
import com.vistara.sdk.utils.APITemplate;
import com.vistara.sdk.utils.SdkUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlertAPIClient
implements APIConstants {
    private static Logger logger = LoggerFactory.getLogger(AlertAPIClient.class);
    private static AlertAPIClient _instance = null;
    private String apiBaseURI = null;
    private String tenantId = null;
    private String appName = null;
    private String authType = "Oauth2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlertAPIClient getInstance(String tenantId, String integrationName) throws Exception {
        if (_instance != null) return _instance;
        Class<AlertAPIClient> clazz = AlertAPIClient.class;
        synchronized (AlertAPIClient.class) {
            if (_instance != null) return _instance;
            _instance = new AlertAPIClient(tenantId, integrationName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlertAPIClient getInstance(String tenantId) throws Exception {
        if (_instance != null) return _instance;
        Class<AlertAPIClient> clazz = AlertAPIClient.class;
        synchronized (AlertAPIClient.class) {
            if (_instance != null) return _instance;
            _instance = new AlertAPIClient(tenantId);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AlertAPIClient getInstance() throws Exception {
        if (_instance != null) return _instance;
        Class<AlertAPIClient> clazz = AlertAPIClient.class;
        synchronized (AlertAPIClient.class) {
            if (_instance != null) return _instance;
            _instance = new AlertAPIClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public AlertAPIClient(String tenantId, String integrationName) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception("Tenant Id should not be null or empty.");
        }
        if (integrationName == null || integrationName.isEmpty()) {
            throw new Exception("Integration Name should not be null or empty.");
        }
        this.tenantId = tenantId;
        this.appName = integrationName;
    }

    public AlertAPIClient(String tenantId) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception("Tenant Id should not be null or empty.");
        }
        this.tenantId = tenantId;
    }

    public AlertAPIClient() throws Exception {
    }

    public String createAlert(String jsonPayload) throws Exception {
        if (jsonPayload == null || jsonPayload.isEmpty()) {
            throw new Exception("JsonPayload should not be null or empty.");
        }
        String apiURL = this.getAPIURL("/alerts");
        return SdkUtil.getInstance().postRequest(apiURL, jsonPayload);
    }

    public String createAlert(List<Alert> alerts) throws Exception {
        if (alerts == null || alerts.isEmpty()) {
            throw new Exception("Alert objects list should not be null or empty");
        }
        Gson gson = new Gson();
        String jsonPayload = gson.toJson(alerts);
        return this.createAlert(jsonPayload);
    }

    public String createAlert(Alert alert) throws Exception {
        if (alert == null) {
            throw new Exception("Alert object should not be null");
        }
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        alerts.add(alert);
        return this.createAlert(alerts);
    }

    public String createAlert(String tenantId, String jsonPayload) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception("Tenant Id should not be null or empty.");
        }
        if (jsonPayload == null || jsonPayload.isEmpty()) {
            throw new Exception("JsonPayload should not be null or empty.");
        }
        String apiURL = this.getAPIURL(tenantId, "/alerts");
        return SdkUtil.getInstance().postRequest(apiURL, jsonPayload);
    }

    public String createAlert(String tenantId, List<Alert> alerts) throws Exception {
        if (alerts == null || alerts.isEmpty()) {
            throw new Exception("Alert objects list should not be null or empty");
        }
        Gson gson = new Gson();
        String jsonPayload = gson.toJson(alerts);
        return this.createAlert(tenantId, jsonPayload);
    }

    public String createAlert(String tenantId, Alert alert) throws Exception {
        if (alert == null) {
            throw new Exception("Alert object should not be null");
        }
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        alerts.add(alert);
        return this.createAlert(tenantId, alerts);
    }

    public String healAlert(String extAlertId) throws Exception {
        if (extAlertId == null || extAlertId.isEmpty()) {
            throw new Exception("Alert extAlertId should not be null or empty");
        }
        String apiURL = this.getAPIURL("/alerts/heal?extAlertId=" + extAlertId);
        return SdkUtil.getInstance().putRequest(apiURL);
    }

    public String healAlerts(String extAlertIds) throws Exception {
        if (extAlertIds == null || extAlertIds.isEmpty()) {
            throw new Exception("Alert extAlertId should not be null or empty");
        }
        String apiURL = this.getAPIURL("/alerts/heal?extAlertIds=" + extAlertIds);
        return SdkUtil.getInstance().putRequest(apiURL);
    }

    public String healAlerts(String tenantId, String extAlertIds) throws Exception {
        if (tenantId == null || tenantId.isEmpty()) {
            throw new Exception("Tenant Id should not be null or empty.");
        }
        if (extAlertIds == null || extAlertIds.isEmpty()) {
            throw new Exception("Alert extAlertId should not be null or empty");
        }
        String apiURL = this.getAPIURL(tenantId, "/alerts/heal?extAlertIds=" + extAlertIds);
        return SdkUtil.getInstance().putRequest(apiURL);
    }

    public String getAlerts(Map<String, String> queryParams) throws Exception {
        String apiURL = this.getAPIURL("/alerts/search");
        if (queryParams != null && queryParams.size() > 0) {
            int i = 1;
            for (Map.Entry<String, String> queryParam : queryParams.entrySet()) {
                if (queryParam.getKey() == null || queryParam.getKey().isEmpty()) continue;
                apiURL = i == 1 ? apiURL + "?" : apiURL + "&";
                apiURL = apiURL + queryParam.getKey() + "=" + queryParam.getValue();
                ++i;
            }
        }
        return SdkUtil.getInstance().getRequest(apiURL);
    }

    private String getAPIURL(String urlSubStr) throws Exception {
        String apiBaseURI = this.getApiBaseURI();
        SdkUtil.getInstance().setApiBaseURI(apiBaseURI);
        String apiURL = apiBaseURI;
        switch (this.authType) {
            case "Oauth2": {
                apiURL = apiURL + "/api/v2/tenants/" + this.tenantId + urlSubStr;
                break;
            }
            case "Basic": {
                apiURL = apiURL + "/api/basic/tenants/" + this.tenantId + urlSubStr;
                break;
            }
            case "Webhook": 
            case "None": {
                apiURL = apiURL + "/integrations/" + this.appName + "/" + this.tenantId + urlSubStr;
                break;
            }
            default: {
                throw new Exception("Invalid authentication type: " + this.authType);
            }
        }
        return apiURL;
    }

    private String getAPIURL(String tenantId, String urlSubStr) throws Exception {
        String apiBaseURI = this.getApiBaseURI();
        SdkUtil.getInstance().setApiBaseURI(apiBaseURI);
        String apiURL = apiBaseURI;
        switch (this.authType) {
            case "Oauth2": {
                apiURL = apiURL + "/api/v2/tenants/" + tenantId + urlSubStr;
                break;
            }
            case "Basic": {
                apiURL = apiURL + "/api/basic/tenants/" + tenantId + urlSubStr;
                break;
            }
            case "Webhook": 
            case "None": {
                apiURL = apiURL + "/integrations/" + this.appName + "/" + tenantId + urlSubStr;
                break;
            }
            default: {
                throw new Exception("Invalid authentication type: " + this.authType);
            }
        }
        return apiURL;
    }

    public void setBasicAuthentication(String apiUserName, String apiPassword) throws Exception {
        if (apiUserName == null || apiUserName.isEmpty()) {
            throw new Exception("API UserName should not be null or empty.");
        }
        if (apiPassword == null || apiPassword.isEmpty()) {
            throw new Exception("API Password should not be null or empty.");
        }
        this.authType = "Basic";
        SdkUtil.getInstance().setApiUserName(apiUserName);
        SdkUtil.getInstance().setApiPassword(apiPassword);
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setOAUTH2Authentication(String apiKey, String apiSecret) throws Exception {
        if (apiKey == null || apiKey.isEmpty()) {
            throw new Exception("API Key should not be null or empty.");
        }
        if (apiSecret == null || apiSecret.isEmpty()) {
            throw new Exception("API Secret should not be null or empty.");
        }
        this.authType = "Oauth2";
        SdkUtil.getInstance().setApiKey(apiKey);
        SdkUtil.getInstance().setApiSecret(apiSecret);
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setWebhookAuthentication(String token) throws Exception {
        this.authType = "Webhook";
        SdkUtil.getInstance().setAccessToken(token);
        SdkUtil.getInstance().setAuthType(this.authType);
    }

    public void setConnectTimeOut(int connectTimeOut) throws Exception {
        SdkUtil.getInstance().setConnectTimeout(connectTimeOut > 0 ? connectTimeOut : -1);
    }

    public void setConnectionRequestTimeOut(int connectionRequestTimeOut) throws Exception {
        SdkUtil.getInstance().setConnectionRequestTimeout(connectionRequestTimeOut > 0 ? connectionRequestTimeOut : -1);
    }

    public void setSocketTimeout(int socketTimeout) throws Exception {
        SdkUtil.getInstance().setSocketTimeout(socketTimeout > 0 ? socketTimeout : -1);
    }

    public static void main(String[] args) {
        try {
            String response = null;
            AlertAPIClient alertApiClient = AlertAPIClient.getInstance("client_4", "Nimsoft");
            alertApiClient.setApiBaseURI("https://192.168.1.23");
            alertApiClient.setOAUTH2Authentication("7U5d9RT4p7jVMjvjvubND98aUUTAvEm3", "Kz3xG6HSWKgveWNDrb7ywTpC5RS5yDmG5VymZbxCybBRtg52Dcw3TTZJxA67N4G8");
            response = alertApiClient.createAlert(AlertAPIClient.getSampleAlert());
            System.out.println("Response :" + response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Alert getSampleAlert() {
        Alert alert = new Alert();
        alert.setServiceName("5b6");
        alert.setSubject("test");
        alert.setAlertTime("2014-11-05 11:26:00");
        alert.setCurrentState("CRITICAL");
        Device device = new Device();
        device.setHostName("NETNERICH-THINK");
        device.setIpAddress("192.168.56.1");
        alert.setDevice(device);
        alert.setAlertType("Maintenance");
        alert.setApp("Vistara");
        alert.setComponent("c");
        alert.setMonitorName("test");
        alert.setSender("Zabbix123");
        alert.setOldState("OK");
        alert.setExtAlertId("1112332");
        alert.setDescription("testing for SDK");
        return alert;
    }

    public void setApiBaseURI(String apiBaseURI) {
        this.apiBaseURI = apiBaseURI;
    }

    public String getApiBaseURI() {
        if (this.apiBaseURI == null) {
            return "https://api.vistara.io";
        }
        return this.apiBaseURI;
    }

    public Results<Alert> getAlertsResults(String cId, String sDate, String eDate, String metric, String rId, int pNo, int pSize) throws Exception {
        String apiURL = AlertAPIClient.getAlertsURL(cId, sDate, eDate, metric, rId, pNo, pSize);
        int retryCnt = 0;
        String jsonData = null;
        Response res = null;
        do {
            try {
                jsonData = APITemplate.getInstance(cId).getRequest(apiURL);
                if (jsonData != null && (res = (Response)new ObjectMapper().readValue(jsonData, (TypeReference)new TypeReference<Response>(){})) != null && res.getStatus().equals("200") && res.getStatus_message() != null) {
                    return (Results)new ObjectMapper().readValue(res.getStatus_message(), (TypeReference)new TypeReference<Results<Alert>>(){});
                }
            }
            catch (Exception e) {
                logger.error(apiURL);
                logger.error(e.getMessage(), e);
            }
        } while ((jsonData == null || res.getStatus().equals("504")) && ++retryCnt < 5);
        return null;
    }

    public List<Alert> getAlerts(String cId, String sDate, String eDate, String metric, String rId) throws Exception {
        ArrayList<Alert> alertList = new ArrayList<Alert>();
        int pageNo = 1;
        int pageSize = 100;
        Results<Alert> results = null;
        do {
            if ((results = this.getAlertsResults(cId, sDate, eDate, metric, rId, pageNo, pageSize)) == null || results.getResults() == null || results.getResults().size() <= 0) continue;
            alertList.addAll(results.getResults());
        } while ((pageNo = results != null && results.isNextPage() ? results.getNextPageNo() : 0) > 0);
        return alertList;
    }

    private static String getAlertsURL(String cId, String sDate, String eDate, String metric, String rIds, int pNo, int pSize) {
        StringBuilder sb = new StringBuilder();
        sb.append("/tenants/").append(cId);
        sb.append("/alerts/search?pageNo=").append(pNo);
        sb.append("&pageSize=").append(pSize);
        sb.append("&queryString=clientIds:").append(cId);
        sb.append("%2BstartDate:").append(sDate);
        sb.append("%2BendDate:").append(eDate);
        sb.append("%2BdeviceStatus:manage+resourceType:DEVICE");
        sb.append("%2BalertTypes:Monitoring");
        sb.append("%2Bmetrics:").append(metric);
        sb.append("%2BresourceIds:").append(rIds);
        return sb.toString();
    }
}

